/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.Static;
import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessExtremeCraftingRecipe;
import committee.nova.mods.avaritia.common.item.singularity.Singularity;
import committee.nova.mods.avaritia.init.event.RegisterRecipesEvent;
import committee.nova.mods.avaritia.init.handler.SingularityRegistryHandler;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber
public class InternalRecipeHandler {
    @SubscribeEvent
    public static void onRegisterRecipes(RegisterRecipesEvent event) {
        List<Singularity> allSingularities = SingularityRegistryHandler.getInstance().getSingularities();
        InfinityCatalystCraftRecipe infinity_catalyst = (InfinityCatalystCraftRecipe)event.getRecipe(Static.rl("infinity_catalyst"));
        if (infinity_catalyst.m_6076_().equals("default")) {
            allSingularities.stream().filter(singularity -> singularity.getIngredient() != Ingredient.f_43901_).limit(81L).map(SingularityUtils::getItemForSingularity).map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).forEach(arg_0 -> infinity_catalyst.inputs.add(arg_0));
            event.addRecipe(new InfinityCatalystCraftRecipe(Static.rl("infinity_catalyst"), "default", infinity_catalyst.inputs));
        }
        for (Singularity singularity2 : SingularityRegistryHandler.getInstance().getSingularities()) {
            CompressorRecipe compressorRecipe;
            if (singularity2.isRecipeDisabled() || (compressorRecipe = InternalRecipeHandler.makeSingularityRecipe(singularity2)) == null) continue;
            event.addRecipe(compressorRecipe);
        }
    }

    private static CompressorRecipe makeSingularityRecipe(Singularity singularity) {
        Ingredient ingredient = singularity.getIngredient();
        if (ingredient == Ingredient.f_43901_) {
            return null;
        }
        ResourceLocation id = singularity.getId();
        ResourceLocation recipeId = new ResourceLocation("avaritia", id.m_135815_() + "_singularity");
        ItemStack output = SingularityUtils.getItemForSingularity(singularity);
        int ingredientCount = singularity.getIngredientCount();
        int timeRequired = singularity.getTimeRequired();
        return new CompressorRecipe(recipeId, ingredient, output, ingredientCount, timeRequired);
    }

    @ApiStatus.Experimental
    public static ShapelessExtremeCraftingRecipe addExtremeShapelessRecipe(ItemStack result, List<ItemStack> ingredients) {
        ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
        for (ItemStack stack : ingredients) {
            if (stack != null) {
                arraylist.add(stack.m_41777_());
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipes!");
        }
        return new ShapelessExtremeCraftingRecipe(ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()), InternalRecipeHandler.getList(arraylist), result);
    }

    private static NonNullList<Ingredient> getList(List<ItemStack> arrayList) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (ItemStack stack : arrayList) {
            ingredients.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
        }
        return ingredients;
    }
}

